# We do not want to load all of M2 mode at startup!
# This file will be sourced when we actually want to load everything
# --- i.e. the first time we use M2 mode.

proc M2load {} {}

#===========================================================================
#  Load other M2 mode files  #
#===========================================================================
# Note, the following should take place on this level, not within a
# procedure, because of all global variables involved in the mode
# initialization.  Moreover, many scripts need to be loaded right away, since
# the mode is likely not to work fully otherwise.  An exception to this are
# m2AdjPrefs (may depend on Alpha version), m2Templates, m2CompErr, m2Utils,
# m2Marking, and m2HelpLookup, which could be loaded only if really needed,
# i.e. e.g. only when an identifier is command^double-clicked.  
#

# proc enterM2Mode is for sure in m2Mode.tcl
set m2ModeDir "[file dirname [procs::find enterM2Mode]]"
if {$m2ModeDir == ""} then {
    set m2ModeDir [file join $HOME Tcl Modes "M2 Mode"]
}

if {![info exists curAlphaV]} then {
    if {[catch {source [file join ${m2ModeDir} m2Mode.tcl]} err]} then {
	alertnote "Encountered error '$err' while sourcing 'm2Mode.tcl'!"
    }
}

# IT IS VITAL WE LOAD THE m2Prefs.tcl FILE NOW.  THE PRIMARY THING
# A MODE MUST ACCOMPLISH IN INITIALISATION IS TO CREATE ALL OF ITS
# PREFERENCES.
foreach tmp {
    m2Prefs m2GlobAux m2Menu m2Bindings m2Config
    m2CompErr m2ShellUse
    m2Syntax m2HelpLookup m2Templates
} {
    if {[file exists [file join ${m2ModeDir} ${tmp}.tcl]]} then {
	if {[catch {source [file join ${m2ModeDir} ${tmp}.tcl]} err]} then {
	    alertnote "Encountered error '$err' while sourcing '${tmp}.tcl'!"
	}
    } else {
	alertnote "M2 mode's file '[file join ${m2ModeDir} ${tmp}.tcl]' seems\
	  to be missing. Could not load it!"
    }
}
unset tmp

# Reporting that end of this script has been reached
message "m2Mode.tcl for Programing in Modula-2 loaded"
